import pytchat
import requests
import re
import os

CONFIG_FILE = "config.txt"

def read_config():
    """Wczytuje ostatnie użyte wartości z pliku konfiguracyjnego."""
    if os.path.exists(CONFIG_FILE):
        with open(CONFIG_FILE, "r", encoding="utf-8") as f:
            lines = f.read().splitlines()
            if len(lines) >= 2:
                return lines[0], lines[1]
    return "", ""

def save_config(chat_url, esp32_ip):
    """Zapisuje wartości do pliku konfiguracyjnego."""
    with open(CONFIG_FILE, "w", encoding="utf-8") as f:
        f.write(chat_url + "\n")
        f.write(esp32_ip + "\n")

def send_to_esp32(esp32_ip, message):
    """Wysyła wiadomość do ESP32 przez HTTP GET w formacie wymaganym przez ESP."""
    url = f"http://{esp32_ip}//&MSG={message}/&"
    try:
        requests.get(url, timeout=1)
        print(f"Wysłano: {message}")
    except requests.exceptions.ConnectionError as e:
        # Ignorujemy gwałtowne zamknięcie połączenia przez ESP
        if "10054" not in str(e):
            print(f"Błąd wysyłki: {e}")
    except requests.exceptions.RequestException as e:
        # Inne wyjątki (timeout, DNS itp.)
        print(f"Błąd wysyłki: {e}")

def main():
    last_chat_url, last_esp32_ip = read_config()

    # Zapytaj o link do czatu
    chat_url = input(f"Wpisz adres czatu [{last_chat_url}]: ").strip()
    if chat_url == "":
        chat_url = last_chat_url
    if chat_url == "":
        print("Nie podano linku do czatu!")
        return

    # Zapytaj o IP ESP32
    esp32_ip = input(f"Wpisz IP tekstscrollera [{last_esp32_ip}]: ").strip()
    if esp32_ip == "":
        esp32_ip = last_esp32_ip
    if esp32_ip == "":
        print("Nie podano IP ESP32!")
        return

    # Zapis konfiguracji
    save_config(chat_url, esp32_ip)

    # Wyciągnięcie video ID z linku
    match = re.search(r"v=([a-zA-Z0-9_-]+)", chat_url)
    if not match:
        print("Nieprawidłowy link do czatu!")
        return

    video_id = match.group(1)
    print(f"Monitoring czatu dla video ID: {video_id}")
    print(f"Wiadomości będą wysyłane do {esp32_ip} (HTTP GET //&MSG=.../&)")

    # Inicjalizacja pytchat
    chat = pytchat.create(video_id=video_id)

    while chat.is_alive():
        for c in chat.get().sync_items():
            message = c.message
            if message.startswith("TEKST:") or message.startswith("TEXT:") or message.startswith("TXT:") or message.startswith("tekst:") or message.startswith("text:") or message.startswith("txt:"):
                text = message.split(":", 1)[1].strip()
                send_to_esp32(esp32_ip, text)

if __name__ == "__main__":
    main()
